// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     device/battery/battery_status.mojom
//

package org.chromium.mojom.device;

public final class BatteryStatus extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 40;
    private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(40, 0)};
    private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

    public boolean charging;
    public double chargingTime;
    public double dischargingTime;
    public double level;

    private BatteryStatus(int version) {
        super(STRUCT_SIZE, version);
        charging = (boolean) true;
        chargingTime = (double) 0.0;
        dischargingTime = (double) java.lang.Double.POSITIVE_INFINITY;
        level = (double) 1.0;
    }

    public BatteryStatus() {
        this(0);
    }

    public static BatteryStatus deserialize(org.chromium.mojo.bindings.Message message) {
        return decode(new org.chromium.mojo.bindings.Decoder(message));
    }

    @SuppressWarnings("unchecked")
    public static BatteryStatus decode(org.chromium.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
        BatteryStatus result = new BatteryStatus(mainDataHeader.elementsOrVersion);
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.charging = decoder0.readBoolean(8, 0);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.chargingTime = decoder0.readDouble(16);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.dischargingTime = decoder0.readDouble(24);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.level = decoder0.readDouble(32);
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        encoder0.encode(charging, 8, 0);
        encoder0.encode(chargingTime, 16);
        encoder0.encode(dischargingTime, 24);
        encoder0.encode(level, 32);
    }

    /**
     * @see Object#equals(Object)
     */
    @Override
    public boolean equals(Object object) {
        if (object == this)
            return true;
        if (object == null)
            return false;
        if (getClass() != object.getClass())
            return false;
        BatteryStatus other = (BatteryStatus) object;
        if (this.charging != other.charging)
            return false;
        if (this.chargingTime != other.chargingTime)
            return false;
        if (this.dischargingTime != other.dischargingTime)
            return false;
        if (this.level != other.level)
            return false;
        return true;
    }

    /**
     * @see Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = prime + getClass().hashCode();
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(charging);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(chargingTime);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(dischargingTime);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(level);
        return result;
    }
}

